﻿//////////////////////////////////////////////
// ScriptObjectView.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class ScriptObjectInterpreterView ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkScripts
{
	class ScriptObjectView final
	{
		public :

			// Constructor, destructor
			ScriptObjectView () noexcept ;
			ScriptObjectView (const ScriptObjectView& other) noexcept ;
			ScriptObjectView (ScriptObjectView&& other) noexcept ;
			~ScriptObjectView () ;

			// Utils
			void reset (nkMemory::UniquePtr<ScriptObjectInterpreterView> view) ;

			// Operators
			ScriptObjectView& operator= (const ScriptObjectView& other) noexcept ;
			ScriptObjectView& operator= (ScriptObjectView&& other) noexcept ;

		public :

			// Attributes
			// Allows to reconstruct a true reference
			// Dedicated to user data, to avoid dangling references within function parameters
			nkMemory::UniquePtr<ScriptObjectInterpreterView> _view ;
	} ;
}